# Reproducing Paper Table Results

This directory contains scripts to reproduce the main results from the Aurora paper.

## Quick Start

```bash
# From repository root
python examples/reproduce_paper_table/generate_main_table.py
```

## Required Data

Download experimental results from Zenodo and extract to `data-for-export/`:

```
data-for-export/
├── deep_drebin_svc/
│   ├── parallel_ce_no_aug_v2.pkl     # DeepDrebin (AndroZoo, API-Graph)
│   ├── parallel_svc_v2.pkl            # Drebin/SVC baseline
│   └── transcendent/                  # Transcendent results
│       ├── deep_drebin_full_*.pkl
│       ├── deep_drebin_subsampled_*.pkl
│       ├── drebin_full_*.pkl
│       └── drebin_subsampled_*.pkl
└── others_v2/
    ├── hcc_mlp_warm-*.json            # HCC results (6 files)
    └── cade_mlp_*.json                # CADE results (6 files)
```

**Total size**: ~8GB

## Scripts

### Main Scripts

| Script | Output | Description |
|--------|--------|-------------|
| `generate_main_table.py` | `results/comprehensive_results_*.tex` | **Main paper table** with all metrics |
| `generate_pareto_table.py` | `results/pareto_table.tex` | Pareto dominance analysis |
| `generate_rejection_table.py` | `results/rejection_table.tex` | Rejection-based metrics |
| `generate_figures.py` | `results/*.png` | Paper figures |

### Supporting Scripts

| Script | Description |
|--------|-------------|
| `load_all_aurora_data.py` | Data loading and quality validation |

## Output Format

The main table (`comprehensive_results_mirror_new_data.tex`) includes:

### Baseline Metrics
- **F1 (%)**: Detection rate
- **FNR (%)**: False negative rate
- **AUROC (%)**: Discrimination ability

### Reliability Metrics
- **AURC**: Uncertainty calibration (error-based risk)
- **AURC[F1]***: F1-based risk over coverage spectrum

### Stability Metrics
- **σ[F1]**: F1 volatility over time
- **τ**: Mann-Kendall trend (>0 = improving)
- **BF***: Benefit Fraction at budget B
- **ΔRej***: Rejection bias at budget B
- **σ[Rej]***: Rejection volatility at budget B

### Pareto Status
- **P**: Pareto status (★ = universal, △ = partial, ○ = dominated)

## Verification

Pre-computed reference tables are in `results/`:

```bash
# Compare generated vs reference
diff results/comprehensive_results_mirror_new_data.tex \
     results/comprehensive_results_mirror_new_data.tex.reference
```

## Troubleshooting

**"File not found" errors**: Ensure `data-for-export/` exists with all required files.

**Import errors**: Install Aurora package from repository root:
```bash
pip install -e .
```

## Dependencies

All dependencies are in `pyproject.toml`. Key requirements:
- Python 3.9+
- NumPy, Pandas, SciPy
- scikit-learn
- tqdm
